/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8282.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm8282.DeviceView.ChassisLike;
import ibm.nways.jdm8282.DeviceView.ChassisUnknown;
import ibm.nways.jdm8282.DeviceView.LeafCompositeLike;
import ibm.nways.ras.RAS;
import java.awt.Component;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class Chassis
implements ChassisLike {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8282.Resources");
    private static ResourceBundle commonResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.CommonFolderGroupResources");
    private static final int RASID = 19;
    private static final int RASSUB = 13;
    private static final String PropertiesFile = "properties/Jdm8282.txt";
    private final Vector components = new Vector();
    protected JdmBrowser jdmBrowser;
    protected GraphicContainer container = new GraphicContainer();

    public void discoverChildren() {
    }

    public void add(LeafCompositeLike leafCompositeLike) {
        this.components.addElement(leafCompositeLike);
    }

    public void setCommonInformation(JdmBrowser jdmBrowser) {
        this.jdmBrowser = jdmBrowser;
    }

    public void draw() {
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            leafCompositeLike.draw();
        }
    }

    public GraphicPanel getGraphicPanel() {
        if (this instanceof ChassisUnknown) {
            return null;
        }
        this.setupLayout(this.jdmBrowser, PropertiesFile);
        return new GraphicPanel((GraphicHandler)this.jdmBrowser, (Component)this.container);
    }

    private void setupLayout(JdmBrowser jdmBrowser, String string) {
        Object object;
        Properties properties = null;
        String string2 = "setupLayout";
        if (RAS.isEnabled(19, 13)) {
            RAS.enter(19, 13, this, string2);
        }
        try {
            object = new URL(jdmBrowser.getDocumentBase(), string);
            properties = new Properties();
            properties.load(((URL)object).openStream());
        }
        catch (Exception exception) {
            RAS.logError(19, 13, this, string2, "EXCEPTION_GETTING_PROPERTIES", (Object)string);
            RAS.logException(19, 13, this, string2, exception);
            if (RAS.isEnabled(19, 13)) {
                RAS.trace(19, 13, this, string2, "Exception getting propertiesFile: " + string);
            }
            properties = null;
        }
        JdmLayout jdmLayout = (JdmLayout)jdmBrowser.getLayout();
        if (properties != null) {
            int n = new Integer((String)((Hashtable)properties).get("layout.scheme"));
            jdmLayout.setScheme(n);
            object = (String)((Hashtable)properties).get("layout.fractions");
            if (RAS.isEnabled(19, 13)) {
                RAS.trace(19, 13, this, string2, "layout scheme,fractions " + n + "," + (String)object);
            }
            StringTokenizer stringTokenizer = new StringTokenizer((String)object);
            float[] fArray = new float[stringTokenizer.countTokens()];
            boolean bl = true;
            int n2 = 0;
            while (n2 < fArray.length && stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    fArray[n2] = Float.valueOf(string3).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    RAS.logError(19, 13, this, string2, "EXCEPTION_CALCULATING_FRACTIONS");
                    RAS.logException(19, 13, this, string2, (Exception)numberFormatException);
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                jdmLayout.setFracts(fArray);
                return;
            }
        } else {
            int n = 0;
            jdmLayout.setScheme(n);
        }
    }
}

